/*
 * Names:   James Sheets
 * Class:   285
 * Due:     2/22/07
 * Desc:    Implement a binary search, and keep a defect log of the process
*/

import java.io.*;

class Client
{
   private int[] numberArray;
   
   /*
    * Program entry-point
   */
   public static void main(String[] args)
   {
      Client search = new Client();
   }
   
   
   /*
    * Default Constructor
    * 
    * Prompts user for a number to search for, and then performs a binary search
    * on a sorted array, and returns the index for the first match found
   */
   public Client()
   {
      try {
         // Ask for input file
         System.out.println("Enter a text file of input numbers: ");
         // Convert to an int
         BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
         // Open the file
         String rawData = new String("");
         FileReader input = new FileReader(br.readLine());
         BufferedReader bufRead = new BufferedReader(input);
         // Read in the data
         boolean eof = false;
         while (!eof)
         {
            String line = bufRead.readLine();
            if (line == null) eof = true;
            else rawData += line + " ";
         }
         bufRead.close();
         
         // Ask for input search number
         System.out.println("Enter a number to search for in our array: ");
         // Convert to an int
         br = new BufferedReader(new InputStreamReader(System.in));
         //BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
         int findIt = Integer.parseInt(br.readLine());
         
         // Parse the input string into our number array
         ParseInput(rawData);
         // Sort our number array
         SelectionSort();
         // Begin recursive search
         int result = BinarySearch(0,numberArray.length-1,findIt);
         // Echo result
         System.out.println("Result found at index: " + result);
      } catch (Exception e) {
         // Generic exception message
         System.out.println("An error occurred");
      }
   }


   /*
    * Parse Input
    * 
    * Parses input string into integers, and puts them in our global array
   */
   public void ParseInput(String rawInput) throws Exception /*** FX3 ***/
   {
      // Regex split
      String[] result = rawInput.split("\\s|\\n");
      // Convert each string to an int, save it in our global array
      numberArray = new int[result.length];
      for (int x=0; x<result.length; x++)
      {
         Integer val = Integer.parseInt(result[x]);
         numberArray[x] = val.intValue();
      }
   }
   
   
   /*
    * SelectionSort algorithm
    *
    * Orders the values in an array
   */
   public void SelectionSort()
   {
      int minimum,temp;
      
      // Iterate over every number in the array
	  for (int i = 0; i < numberArray.length - 1; i++) /*** FX3 ***/
      {
         minimum = i;
         
         // Check to see if any number after this one's position in the array is
         // smaller than the one in our previous loop.
		 for (int j = i + 1; j < numberArray.length; j++)
         {
            // Save the index of the smallest number found, if there is one
            if (numberArray[j] < numberArray[minimum]) 
               minimum = j;
         }
         
         // Perform the swap
         // (if we didn't find a smaller number, it just swaps with itself)
         temp = numberArray[i];
         numberArray[i] = numberArray[minimum];
         numberArray[minimum] = temp;
      }
   }
   
   
   /*
    * Recursive Binary Search algorithm
    *
    * This was developed on-the-fly, hence it could most likely be refined.
    * We assume the array has been initialized, and has at least one vallue.  
    * We also assume that the start/end indexes being passed in are valid.
   */
   public int BinarySearch(int start, int end, int find) throws Exception
   {
      // We're down to one or two indexes; recursion must end
	  if (end - start <= 1) /*** FX1 ***/
      {
         // Match on start
         if (numberArray[start] == find)
            return start;
         // Match on end (end might equal start, which would make this unnecessary)
         else if (numberArray[end] == find)
            return end;
         // No match exists; give a non-existant index
         else
            return -1;
      }
      // There's at least three indexes
      else
      {
         // Get the middle index
		 int middle = (int)((end + start) / 2); /*** FX6 ***/
         // Check if the middle index matches our find value
		 if (numberArray[middle] == find) /*** FX4 ***/
         {
            return middle;
         }
         else
         {
            // Number should be in the lower half
            if (find < numberArray[middle])
			   return BinarySearch(start, middle - 1, find); /*** FX5 ***/
            // Number should be in the upper half
            else
			   return BinarySearch(middle + 1, end, find); /*** FX5 ***/
         }
      }
   }
}